using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;
using System.IO;

namespace Perftest_with_TicCount
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
         private DataSet ds;  
         private dsTitles dsStrong; 
         private SqlConnection cn; 
         private SqlDataAdapter da;
         private float result;
         private int i;
         private int Sample1;
         private int Sample2;
         enum enuTitles { Title ,Price, PubDate }


        internal System.Data.SqlClient.SqlDataAdapter SqlDataAdapter1;
        internal System.Data.SqlClient.SqlCommand SqlDeleteCommand1;
        internal System.Data.SqlClient.SqlConnection SqlConnection1;
        internal System.Data.SqlClient.SqlCommand SqlInsertCommand1;
        internal System.Data.SqlClient.SqlCommand SqlSelectCommand1;
        internal System.Data.SqlClient.SqlCommand SqlUpdateCommand1;
        internal System.Windows.Forms.TextBox txtLoops;
        internal System.Windows.Forms.Label Label1;
        internal System.Windows.Forms.Button Button2;
        internal System.Windows.Forms.ListBox ListBox1;
        internal System.Windows.Forms.Button Button1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
            try
            {
                //
                // Required for Windows Form Designer support
                //
                InitializeComponent();

                //
                // TODO: Add any constructor code after InitializeComponent call
                //
                
                ds = new DataSet();
                dsStrong = new dsTitles();
                cn = new SqlConnection();
                da = new SqlDataAdapter("Select top 5 Title,Price,PubDate, * from titles", cn);
            
            
                ListBox1.Items.Clear();
                Sample1 = Environment.TickCount;
                System.Threading.Thread.Sleep(200); // Throw away first tick
                Sample1 = Environment.TickCount;
                cn.ConnectionString = "data source=.;database=pubs;uid=admin;pwd=pw";
                da.Fill(ds, "Titles");
                SqlDataAdapter1.Fill(dsStrong, "Titles");
                Sample2 = Environment.TickCount;    // a second sample.

                // Pass both samples to the Calculate method.
                result = Sample2 - Sample1;
                ListBox1.Items.Add( result.ToString()+ "(ms)\t: Connect and fill" );
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.SqlDataAdapter1 = new System.Data.SqlClient.SqlDataAdapter();
            this.SqlDeleteCommand1 = new System.Data.SqlClient.SqlCommand();
            this.SqlConnection1 = new System.Data.SqlClient.SqlConnection();
            this.SqlInsertCommand1 = new System.Data.SqlClient.SqlCommand();
            this.SqlSelectCommand1 = new System.Data.SqlClient.SqlCommand();
            this.SqlUpdateCommand1 = new System.Data.SqlClient.SqlCommand();
            this.txtLoops = new System.Windows.Forms.TextBox();
            this.Label1 = new System.Windows.Forms.Label();
            this.Button2 = new System.Windows.Forms.Button();
            this.ListBox1 = new System.Windows.Forms.ListBox();
            this.Button1 = new System.Windows.Forms.Button();
            this.SuspendLayout();
            // 
            // SqlDataAdapter1
            // 
            this.SqlDataAdapter1.DeleteCommand = this.SqlDeleteCommand1;
            this.SqlDataAdapter1.InsertCommand = this.SqlInsertCommand1;
            this.SqlDataAdapter1.SelectCommand = this.SqlSelectCommand1;
            this.SqlDataAdapter1.TableMappings.AddRange(new System.Data.Common.DataTableMapping[] {
                                                                                                      new System.Data.Common.DataTableMapping("Table", "titles", new System.Data.Common.DataColumnMapping[] {
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("Expr1", "Expr1"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("Expr2", "Expr2"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("Expr3", "Expr3"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("title_id", "title_id"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("title", "title"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("type", "type"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("pub_id", "pub_id"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("price", "price"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("advance", "advance"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("royalty", "royalty"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("ytd_sales", "ytd_sales"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("notes", "notes"),
                                                                                                                                                                                                                new System.Data.Common.DataColumnMapping("pubdate", "pubdate")})});
            this.SqlDataAdapter1.UpdateCommand = this.SqlUpdateCommand1;
            // 
            // SqlDeleteCommand1
            // 
            this.SqlDeleteCommand1.CommandText = @"DELETE FROM titles WHERE (title_id = @Original_title_id) AND (title = @Original_title) AND (price = @Original_price OR @Original_price IS NULL AND price IS NULL) AND (pubdate = @Original_pubdate) AND (advance = @Original_advance OR @Original_advance IS NULL AND advance IS NULL) AND (notes = @Original_notes OR @Original_notes IS NULL AND notes IS NULL) AND (price = @Original_Expr2 OR @Original_Expr2 IS NULL AND price IS NULL) AND (pub_id = @Original_pub_id OR @Original_pub_id IS NULL AND pub_id IS NULL) AND (pubdate = @Original_Expr3) AND (royalty = @Original_royalty OR @Original_royalty IS NULL AND royalty IS NULL) AND (title = @Original_Expr1) AND (type = @Original_type) AND (ytd_sales = @Original_ytd_sales OR @Original_ytd_sales IS NULL AND ytd_sales IS NULL)";
            this.SqlDeleteCommand1.Connection = this.SqlConnection1;
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_title_id", System.Data.SqlDbType.VarChar, 6, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "title_id", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_title", System.Data.SqlDbType.VarChar, 80, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "title", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_price", System.Data.SqlDbType.Money, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "price", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_pubdate", System.Data.SqlDbType.DateTime, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "pubdate", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_advance", System.Data.SqlDbType.Money, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "advance", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_notes", System.Data.SqlDbType.VarChar, 200, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "notes", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_Expr2", System.Data.SqlDbType.Money, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "price", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_pub_id", System.Data.SqlDbType.VarChar, 4, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "pub_id", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_Expr3", System.Data.SqlDbType.DateTime, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "pubdate", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_royalty", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "royalty", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_Expr1", System.Data.SqlDbType.VarChar, 80, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "title", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_type", System.Data.SqlDbType.VarChar, 12, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "type", System.Data.DataRowVersion.Original, null));
            this.SqlDeleteCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_ytd_sales", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "ytd_sales", System.Data.DataRowVersion.Original, null));
            // 
            // SqlConnection1
            // 
            this.SqlConnection1.ConnectionString = "data source=.;initial catalog=pubs;integrated security=SSPI;persist security info" +
                "=False;workstation id=BETAV9;packet size=4096";
            // 
            // SqlInsertCommand1
            // 
            this.SqlInsertCommand1.CommandText = @"INSERT INTO titles(title, price, pubdate, title_id, type, pub_id, advance, royalty, ytd_sales, notes) VALUES (@title, @price, @pubdate, @title_id, @type, @pub_id, @advance, @royalty, @ytd_sales, @notes); SELECT TOP 5 title AS Expr1, price AS Expr2, pubdate AS Expr3, title_id, title, type, pub_id, price, advance, royalty, ytd_sales, notes, pubdate FROM titles WHERE (title_id = @title_id)";
            this.SqlInsertCommand1.Connection = this.SqlConnection1;
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@title", System.Data.SqlDbType.VarChar, 80, "title"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@price", System.Data.SqlDbType.Money, 8, "price"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@pubdate", System.Data.SqlDbType.DateTime, 8, "pubdate"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@title_id", System.Data.SqlDbType.VarChar, 6, "title_id"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@type", System.Data.SqlDbType.VarChar, 12, "type"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@pub_id", System.Data.SqlDbType.VarChar, 4, "pub_id"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@advance", System.Data.SqlDbType.Money, 8, "advance"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@royalty", System.Data.SqlDbType.Int, 4, "royalty"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@ytd_sales", System.Data.SqlDbType.Int, 4, "ytd_sales"));
            this.SqlInsertCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@notes", System.Data.SqlDbType.VarChar, 200, "notes"));
            // 
            // SqlSelectCommand1
            // 
            this.SqlSelectCommand1.CommandText = "SELECT TOP 5 title AS Expr1, price AS Expr2, pubdate AS Expr3, title_id, title, t" +
                "ype, pub_id, price, advance, royalty, ytd_sales, notes, pubdate FROM titles";
            this.SqlSelectCommand1.Connection = this.SqlConnection1;
            // 
            // SqlUpdateCommand1
            // 
            this.SqlUpdateCommand1.CommandText = @"UPDATE titles SET title = @title, price = @price, pubdate = @pubdate, title_id = @title_id, type = @type, pub_id = @pub_id, advance = @advance, royalty = @royalty, ytd_sales = @ytd_sales, notes = @notes WHERE (title_id = @Original_title_id) AND (title = @Original_title) AND (price = @Original_price OR @Original_price IS NULL AND price IS NULL) AND (pubdate = @Original_pubdate) AND (advance = @Original_advance OR @Original_advance IS NULL AND advance IS NULL) AND (notes = @Original_notes OR @Original_notes IS NULL AND notes IS NULL) AND (price = @Original_Expr2 OR @Original_Expr2 IS NULL AND price IS NULL) AND (pub_id = @Original_pub_id OR @Original_pub_id IS NULL AND pub_id IS NULL) AND (pubdate = @Original_Expr3) AND (royalty = @Original_royalty OR @Original_royalty IS NULL AND royalty IS NULL) AND (title = @Original_Expr1) AND (type = @Original_type) AND (ytd_sales = @Original_ytd_sales OR @Original_ytd_sales IS NULL AND ytd_sales IS NULL); SELECT TOP 5 title AS Expr1, price AS Expr2, pubdate AS Expr3, title_id, title, type, pub_id, price, advance, royalty, ytd_sales, notes, pubdate FROM titles WHERE (title_id = @title_id)";
            this.SqlUpdateCommand1.Connection = this.SqlConnection1;
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@title", System.Data.SqlDbType.VarChar, 80, "title"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@price", System.Data.SqlDbType.Money, 8, "price"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@pubdate", System.Data.SqlDbType.DateTime, 8, "pubdate"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@title_id", System.Data.SqlDbType.VarChar, 6, "title_id"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@type", System.Data.SqlDbType.VarChar, 12, "type"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@pub_id", System.Data.SqlDbType.VarChar, 4, "pub_id"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@advance", System.Data.SqlDbType.Money, 8, "advance"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@royalty", System.Data.SqlDbType.Int, 4, "royalty"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@ytd_sales", System.Data.SqlDbType.Int, 4, "ytd_sales"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@notes", System.Data.SqlDbType.VarChar, 200, "notes"));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_title_id", System.Data.SqlDbType.VarChar, 6, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "title_id", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_title", System.Data.SqlDbType.VarChar, 80, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "title", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_price", System.Data.SqlDbType.Money, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "price", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_pubdate", System.Data.SqlDbType.DateTime, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "pubdate", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_advance", System.Data.SqlDbType.Money, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "advance", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_notes", System.Data.SqlDbType.VarChar, 200, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "notes", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_Expr2", System.Data.SqlDbType.Money, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "price", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_pub_id", System.Data.SqlDbType.VarChar, 4, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "pub_id", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_Expr3", System.Data.SqlDbType.DateTime, 8, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "pubdate", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_royalty", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "royalty", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_Expr1", System.Data.SqlDbType.VarChar, 80, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "title", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_type", System.Data.SqlDbType.VarChar, 12, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "type", System.Data.DataRowVersion.Original, null));
            this.SqlUpdateCommand1.Parameters.Add(new System.Data.SqlClient.SqlParameter("@Original_ytd_sales", System.Data.SqlDbType.Int, 4, System.Data.ParameterDirection.Input, false, ((System.Byte)(0)), ((System.Byte)(0)), "ytd_sales", System.Data.DataRowVersion.Original, null));
            // 
            // txtLoops
            // 
            this.txtLoops.Location = new System.Drawing.Point(512, 48);
            this.txtLoops.Name = "txtLoops";
            this.txtLoops.Size = new System.Drawing.Size(104, 20);
            this.txtLoops.TabIndex = 7;
            this.txtLoops.Text = "1000000";
            // 
            // Label1
            // 
            this.Label1.Location = new System.Drawing.Point(504, 16);
            this.Label1.Name = "Label1";
            this.Label1.Size = new System.Drawing.Size(120, 24);
            this.Label1.TabIndex = 8;
            this.Label1.Text = "Loops";
            // 
            // Button2
            // 
            this.Button2.Location = new System.Drawing.Point(512, 168);
            this.Button2.Name = "Button2";
            this.Button2.Size = new System.Drawing.Size(96, 40);
            this.Button2.TabIndex = 6;
            this.Button2.Text = "Dump List To File";
            this.Button2.Click += new System.EventHandler(this.Button2_Click);
            // 
            // ListBox1
            // 
            this.ListBox1.Font = new System.Drawing.Font("Trebuchet MS", 11.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.ListBox1.ItemHeight = 20;
            this.ListBox1.Location = new System.Drawing.Point(24, 8);
            this.ListBox1.Name = "ListBox1";
            this.ListBox1.SelectionMode = System.Windows.Forms.SelectionMode.MultiExtended;
            this.ListBox1.Size = new System.Drawing.Size(440, 384);
            this.ListBox1.TabIndex = 4;
            // 
            // Button1
            // 
            this.Button1.Location = new System.Drawing.Point(512, 120);
            this.Button1.Name = "Button1";
            this.Button1.Size = new System.Drawing.Size(96, 24);
            this.Button1.TabIndex = 5;
            this.Button1.Text = "Run Tests";
            this.Button1.Click += new System.EventHandler(this.Button1_Click);
            // 
            // Form1
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(640, 445);
            this.Controls.AddRange(new System.Windows.Forms.Control[] {
                                                                          this.Button2,
                                                                          this.ListBox1,
                                                                          this.Button1,
                                                                          this.txtLoops,
                                                                          this.Label1});
            this.Name = "Form1";
            this.Text = "Form1";
            this.ResumeLayout(false);

        }
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}

        private void Button1_Click(object sender, System.EventArgs e)
        {
            try
            {
                int intLoops = Convert.ToInt32(txtLoops.Text);
                int intN = 0;
                string[] strA = new string[intLoops + 1];
            
                // Test -2
                string strTable = "Titles";
                string strCol = "Title";
                Sample1 = Environment.TickCount;
                for (i = 0; i <= intLoops; i++)
                {
                    // strA(i) = ds.Tables(strTable).Rows(intN).Item(strCol)
                    strA[i] = ds.Tables[strTable].Rows[intN][strCol].ToString();
                }
                Sample2 = Environment.TickCount;
                result = Sample2 - Sample1;
                ListBox1.Items.Add(result + "\t: Tables[strTable].Rows[intN][strCol]");


                // Test -1
                Sample1 = Environment.TickCount;
                for (i = 0; i <= intLoops; i++)
                {
                    // strA(i) = ds.Tables("Titles").Rows(intN).Item("Title")
                    strA[i] = ds.Tables["Titles"].Rows[intN]["Title"].ToString();
                }
                
                Sample2 = Environment.TickCount;
                result = Sample2 - Sample1;
                ListBox1.Items.Add(result + "\t: Tables[\"Titles\"].Rows[intN][\"Title\"]");

                // Test 0

                Sample1 = Environment.TickCount;
                for (i = 0; i <= intLoops; i++)
                {
                    // strA(i) = ds.Tables(strTable).Rows(intN).Item("Title")
                    strA[i] = ds.Tables[strTable].Rows[intN]["Title"].ToString();
                }
                Sample2 = Environment.TickCount;
                result = Sample2 - Sample1;
                ListBox1.Items.Add(result + "\t: Tables[strTable].Rows[intN][\"Title\"]");


                //Test 1
                Sample1 = Environment.TickCount;
                for (i = 0; i <= intLoops; i++)
                {
                    // VB strA(i) = ds.Tables("Titles").Rows(0).Item("Title")
                    strA[i] = ds.Tables["Titles"].Rows[0]["Title"].ToString();
                }
                Sample2 = Environment.TickCount;
                result = Sample2 - Sample1;
                ListBox1.Items.Add(result + "\t: Tables[\"Titles\"].Rows[0][\"Title\"]");
            
                // Test 2
                Sample1 = Environment.TickCount;
                for (i = 0; i <= intLoops; i++)
                {
                    // VB strA(i) = ds.Tables(0).Rows(0).Item("Title")
                    strA[i] = ds.Tables[0].Rows[0]["Title"].ToString();
                }
                Sample2 = Environment.TickCount;
                result = Sample2 - Sample1;
                ListBox1.Items.Add(result + "\t: Tables[0].Rows[0][\"Title\"]");
            
                // Test 3
                Sample1 = Environment.TickCount;
                for (i = 0; i <= intLoops; i++)
                {
                    // VB strA(i) = ds.Tables(0).Rows(0).Item(0)
                    strA[i] = ds.Tables[0].Rows[0][0].ToString();
                }
                Sample2 = Environment.TickCount;
                result = Sample2 - Sample1;
                ListBox1.Items.Add(result+ "\t: Tables[0].Rows[0][0]");
            
                // Test 4
                Sample1 = Environment.TickCount;
                for (i = 0; i <= intLoops; i++)
                {
                    // VB strA(i) = ds.Tables(0).Rows(0).Item(enuTitles.Title) 
                    strA[i] = ds.Tables[0].Rows[0][(int) enuTitles.Title].ToString();
                }
                Sample2 = Environment.TickCount;
                result = Sample2 - Sample1;
                ListBox1.Items.Add(result + "\t: Tables[0].Rows[0][enum]");

                // Test 5
                dsTitles.titlesRow tRow;
                for (i = 0; i <= intLoops; i++)
                {   
                    Sample1 = Environment.TickCount;
                    tRow = dsStrong.titles[0];
                    for (i = 0; i <= intLoops; i++)
                    {
                        //VB strA(i) = tRow.title
                        strA[i] = tRow.title;
                    }
                    Sample2 = Environment.TickCount;
                    result = Sample2 - Sample1;
                    ListBox1.Items.Add(result + "\t: Strongly Typed");
                
                }

                // Test 6
                
                DataColumn colTitle;
                DataRow dRow2;
                
                Sample1 = Environment.TickCount;
                colTitle = ds.Tables[0].Columns[0];
                dRow2 = ds.Tables[0].Rows[0] ;

                for (i = 0; i <= intLoops; i++)
                {
                    //VB strA(i) = dRow[0].ToString
                    strA[i] = dRow2[colTitle].ToString();
                }
                Sample2 = Environment.TickCount;
                result = Sample2 - Sample1;
                ListBox1.Items.Add(result + "\t: DataRow[DataColumn]");

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
        }

        private void Button2_Click(object sender, System.EventArgs e)
        {
            FileInfo fi = new FileInfo(@"c:\perftest.txt");

            // create a writer, ready to add entries to the file
            StreamWriter sw = fi.AppendText();
            
            sw.WriteLine();
            sw.WriteLine("Tests Run On: " + DateTime.Now.ToString());

            for (short i = 0;i < ListBox1.Items.Count; i++)
            {
                sw.WriteLine( ListBox1.Items[i].ToString());
            }

            sw.Flush();
            sw.Close();
           
        }

   }
}
